<?php
/*
 * @package		Joomla.Framework
 * @copyright	Copyright (C) 2005 - 2010 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 *
 * @component Phoca Plugin
 * @copyright Copyright (C) Marcinko Ernest www.offlajn.com
 * @license http://www.gnu.org/copyleft/gpl.html GNU General Public License version 2 or later;
 */

defined( '_JEXEC' ) or die( 'Restricted access' );
jimport( 'joomla.plugin.plugin' );
jimport( 'joomla.utilities.simplexml' );

if(!version_compare(JVERSION,'1.6.0','ge')) {
	$mainframe->registerEvent('onSearch', 'plgSearchOziogallery');
	$mainframe->registerEvent('onSearchAreas', 'plgSearchOziogalleryAreas');
}


/*
Joomla 1.5
*/

function plgSearchOziogalleryAreas() {
	static $areas = array(
		'oziogallery' => 'Ozio gallery Search plugin'
		);
		return $areas;
}


function plgSearchOziogallery( $text, $phrase = '', $ordering = '', $areas = null ) {

  function read_all_files($root = '.'){
    $files  = array('files'=>array(), 'dirs'=>array());
    $directories  = array();
    $last_letter  = $root[strlen($root)-1];
    $root  = ($last_letter == '\\' || $last_letter == '/') ? $root : $root.DIRECTORY_SEPARATOR;   
    $directories[]  = $root;     
    while (sizeof($directories)) {
      $dir  = array_pop($directories);
      if ($handle = opendir($dir)) {
        while (false !== ($file = readdir($handle))) {
          if ($file == '.' || $file == '..') {
            continue;
          }
          $file  = $dir.$file;
          if (is_dir($file)) {
            $directory_path = $file.DIRECTORY_SEPARATOR;
            array_push($directories, $directory_path);
            $files['dirs'][]  = $directory_path;
          } elseif (is_file($file)) {
            if (fnmatch("*.ozio",$file))
              $files['files'][]  = $file;
          }
        }
        closedir($handle);
      }
    }    
    return $files;
  } 
    
function readXML($text, $dir, $titleReg, $imagesReg, $linksReg, $descReg) {    
  $results = array();
  $files = read_all_files($dir);
  if (is_array($files['files'])) {
    foreach ($files['files'] as $file) {
      $titles = array();
      $images = array();
      $links = array();
      $descriptions = array();
      $c = file_get_contents($file);
      preg_match_all($titleReg, $c, $titles);
      preg_match_all($imagesReg, $c, $images);
      preg_match_all($linksReg, $c, $links);
      preg_match_all($descReg, $c, $descriptions);
      if (is_array($images[1])) {
        for ($i=0;$i<count($images[1]);$i++) { 
          if (strpos($images[1][$i], "exemple.xx")<=0) {   
            $res = new stdClass();
            $res->title =  $titles[1][$i];
            $res->image =  $images[1][$i];
            $res->href =  $links[1][$i];
            $res->text = $descriptions[1][$i];
            $words = array();
            $words = explode(' ', $text);
            foreach ($words as $word) {
              if ($word!="" && strpos($res->title, $word)!==false) {
                $results[] = $res;
                break;
              }
            }
          }
        }
      }
    }
  }
  return $results;       
}    

$results = array();
$db = & JFactory::getDBO();
$db->setQuery("SELECT * FROM #__menu WHERE link LIKE '%oziogallery%'");
$menus = $db->loadObjectList();
foreach ($menus as $menu) {
  if ($menu->params!="") {
    preg_match('/view=[0-9][0-9](.*)$/', $menu->link, $type);
    $dir = dirname(__FILE__).DS."..".DS."..".DS."components".DS."com_oziogallery2".DS."skin".DS.$type[1].DS;
    switch ($type[1]) {
      case "accordion":
        $files = read_all_files($dir);
        if (is_array($files['files'])) {
          foreach ($files['files'] as $file) {
            @$xml->loadFile($file);
            foreach ($xml->document->_children as $child) {
              if (strpos($child->_attributes['jpg'], "exemple.xx")<=0) {
                $xml = new JSimpleXML; 
                $res = new stdClass();
                $res->title =  $child->_attributes['title'];
                $res->image =  $child->_attributes['jpg'];
                $res->href =  $child->_attributes['link'];
                $res->text = $child->_attributes['title'];
                $words = array();
                $words = explode(' ', $text);
                foreach ($words as $word) {
                  if ($word!="" && strpos($res->title, $word)!==false) {
                    $results[] = $res;
                    break;
                  }
                }
              }
            }
          }
        }           
        break;
      case "imagerotator":
        $files = read_all_files($dir);
        if (is_array($files['files'])) {
          foreach ($files['files'] as $file) {
            $xml = new JSimpleXML;
            @$xml->loadFile($file);
            foreach ($xml->document->_children[0]->_children as $child) {
              if (strpos( $child->_children[2]->_data, "exemple.xx")<=0) {   
                $res = new stdClass();
                $res->title =  $child->_children[0]->_data;
                $res->image =  $child->_children[2]->_data;
                $res->href =  $child->_children[2]->_data;
                $res->text = $child->_children[0]->_data;
                $words = array();
                $words = explode(' ', $text);
                foreach ($words as $word) {
                  if ($word!="" && strpos($res->title, $word)!==false) {
                    $results[] = $res;
                    break;
                  }
                }
              }
            }
          }
        }           
        break;
      case "carousel":
        $files = read_all_files($dir);
        if (is_array($files['files'])) {
          foreach ($files['files'] as $file) {
            $xml = new JSimpleXML;
            @$xml->loadFile($file);
            foreach ($xml->document->photo as $child) {
              if (strpos($child->_data, "exemple.xx")<=0) {
                $res = new stdClass();
                $res->title =  $child->_attributes['title'];
                $res->image =  $child->_data;
                $res->href =  $child->_data;
                $res->text = $child->_attributes['title'];
                $words = array();
                $words = explode(' ', $text);
                foreach ($words as $word) {
                  if ($word!="" && strpos($res->title, $word)!==false) {
                    $results[] = $res;
                    break;
                  }
                }
              }
            }
          }
        }             
        break;
      case "cooliris":
        $results = array_merge ($results, readXML($text, $dir,'/title>(.*)<\/title/', '/thumbnail\surl="(.*)"\/>/', '/thumbnail\surl="(.*)"\/>/', '/title>(.*)<\/title/'));
        break;
      case "flashgallery":
        $results = array_merge ($results, readXML($text, $dir,'/title="\/(.*)\/"\/>/', '/<pic\ssrc="(.*)"\stitle=/', '/<pic\ssrc="(.*)"\stitle=/', '/title="\/(.*)\/"\/>/'));
        break;
      case "futura":
        $files = read_all_files($dir);
        if (is_array($files['files'])) {
          foreach ($files['files'] as $file) {
             $xml = new JSimpleXML;
            @$xml->loadFile($file);
            foreach ($xml->document->pic as $child) {
              if (strpos($child->_attributes['image'], "exemple.xx")<=0) {
                $res = new stdClass();
                $res->title =  $child->_attributes['title'];
                $res->image =  $child->_attributes['image'];
                $res->href =  $child->_attributes['image'];
                $res->text = $child->_attributes['title'];
                $words = array();
                $words = explode(' ', $text);
                foreach ($words as $word) {
                  if ($word!="" && strpos($res->title, $word)!==false) {
                    $results[] = $res;
                    break;
                  }
                }
              }
            }
          }
        }           
        break;
      case "tilt3d":
        $dir = dirname(__FILE__).DS."..".DS."..".DS."components".DS."com_oziogallery2".DS."skin".DS."tiltviewer".DS;
        
        $files = read_all_files($dir);
        if (is_array($files['files'])) {
          foreach ($files['files'] as $file) {
            $xml = new JSimpleXML;
            @$xml->loadFile($file);
            foreach ($xml->document->photos[0]->photo as $child) {
              if (strpos($child->_attributes['imageurl'], "exemple.xx")<=0) {
                $res = new stdClass();
                $res->title =  $child->title[0]->_data;
                $res->image =  $child->_attributes['imageurl'];
                $res->href =  $child->_attributes['linkurl'];
                $res->text = $child->description[0]->_data;
                $words = array();
                $words = explode(' ', $text);
                foreach ($words as $word) {
                  if ($word!="" && strpos($res->title, $word)!==false) {
                    $results[] = $res;
                    break;
                  }
                }
              }
            }
          }
        }           
        break;
    }

  }
}

return $results;
}


class plgSearchOziogallery extends JPlugin
{


	public function __construct(& $subject, $config) {
		parent::__construct($subject, $config);
		$this->loadLanguage();
	}
	
	function onContentSearchAreas() {
		static $areas = array(
			'oziogallery' => 'Ozio gallery Search plugin'
			);
			return $areas;
	}

	function onContentSearch( $text, $phrase = '', $ordering = '', $areas = null ) {
  
    function read_all_files($root = '.'){
      $files  = array('files'=>array(), 'dirs'=>array());
      $directories  = array();
      $last_letter  = $root[strlen($root)-1];
      $root  = ($last_letter == '\\' || $last_letter == '/') ? $root : $root.DIRECTORY_SEPARATOR;   
      $directories[]  = $root;     
      while (sizeof($directories)) {
        $dir  = array_pop($directories);
        if ($handle = opendir($dir)) {
          while (false !== ($file = readdir($handle))) {
            if ($file == '.' || $file == '..') {
              continue;
            }
            $file  = $dir.$file;
            if (is_dir($file)) {
              $directory_path = $file.DIRECTORY_SEPARATOR;
              array_push($directories, $directory_path);
              $files['dirs'][]  = $directory_path;
            } elseif (is_file($file)) {
              if (fnmatch("*.ozio",$file))
                $files['files'][]  = $file;
            }
          }
          closedir($handle);
        }
      }    
      return $files;
    } 
    
    function readXML($text, $dir, $titleReg, $imagesReg, $linksReg, $descReg) {    
      $results = array();
      $files = read_all_files($dir);
      if (is_array($files['files'])) {
        foreach ($files['files'] as $file) {
          $titles = array();
          $images = array();
          $links = array();
          $descriptions = array();
          $c = file_get_contents($file);
          preg_match_all($titleReg, $c, $titles);
          preg_match_all($imagesReg, $c, $images);
          preg_match_all($linksReg, $c, $links);
          preg_match_all($descReg, $c, $descriptions);
          if (is_array($images[1])) {
            for ($i=0;$i<count($images[1]);$i++) { 
              if (strpos($images[1][$i], "exemple.xx")<=0) {   
                $res = new stdClass();
                $res->title =  $titles[1][$i];
                $res->image =  $images[1][$i];
                $res->href =  $links[1][$i];
                $res->text = $descriptions[1][$i];
                $words = array();
                $words = explode(' ', $text);
                foreach ($words as $word) {
                  if ($word!="" && strpos($res->title, $word)!==false) {
                    $results[] = $res;
                    break;
                                    
                  }
                }
              }
            }
          }
        }
      }
      return $results;       
    }    
    
    $results = array();
    $db = & JFactory::getDBO();
    $db->setQuery("SELECT * FROM #__menu WHERE link LIKE '%oziogallery%'");
    $menus = $db->loadObjectList();
    foreach ($menus as $menu) {
      if ($menu->params!="") {
        preg_match('/view=[0-9][0-9](.*)$/', $menu->link, $type);
        $dir = dirname(__FILE__).DS."..".DS."..".DS."..".DS."components".DS."com_oziogallery3".DS."skin".DS.$type[1].DS;
        switch ($type[1]) {
          case "accordion":
            $files = read_all_files($dir);
            if (is_array($files['files'])) {
              foreach ($files['files'] as $file) {
                @$xml->loadFile($file);
                foreach ($xml->document->_children as $child) {
                  if (strpos($child->_attributes['jpg'], "exemple.xx")<=0) {
                    $xml = new JSimpleXML; 
                    $res = new stdClass();
                    $res->title =  $child->_attributes['title'];
                    $res->image =  $child->_attributes['jpg'];
                    $res->href =  $child->_attributes['link'];
                    $res->text = $child->_attributes['title'];
                    $words = array();
                    $words = explode(' ', $text);
                    foreach ($words as $word) {
                      if ($word!="" && strpos($res->title, $word)!==false) {
                        $results[] = $res;
                        break;
                      }
                    }
                  }
                }
              }
            }           
            break;
          case "imagerotator":
            $files = read_all_files($dir);
            if (is_array($files['files'])) {
              foreach ($files['files'] as $file) {
                $xml = new JSimpleXML;
                @$xml->loadFile($file);
                foreach ($xml->document->_children[0]->_children as $child) {
                  if (strpos( $child->_children[2]->_data, "exemple.xx")<=0) {   
                    $res = new stdClass();
                    $res->title =  $child->_children[0]->_data;
                    $res->image =  $child->_children[2]->_data;
                    $res->href =  $child->_children[2]->_data;
                    $res->text = $child->_children[0]->_data;
                    $words = array();
                    $words = explode(' ', $text);
                    foreach ($words as $word) {
                      if ($word!="" && strpos($res->title, $word)!==false) {
                        $results[] = $res;
                        break;
                      }
                    }
                  }
                }
              }
            }           
            break;
          case "carousel":
            $files = read_all_files($dir);
            if (is_array($files['files'])) {
              foreach ($files['files'] as $file) {
                $xml = new JSimpleXML;
                @$xml->loadFile($file);
                foreach ($xml->document->photo as $child) {
                  if (strpos($child->_data, "exemple.xx")<=0) {
                    $res = new stdClass();
                    $res->title =  $child->_attributes['title'];
                    $res->image =  $child->_data;
                    $res->href =  $child->_data;
                    $res->text = $child->_attributes['title'];
                    $words = array();
                    $words = explode(' ', $text);
                    foreach ($words as $word) {
                      if ($word!="" && strpos($res->title, $word)!==false) {
                        $results[] = $res;
                        break;
                      }
                    }
                  }
                }
              }
            }             
            break;
          case "cooliris":
            $results = array_merge ($results, readXML($text, $dir,'/title>(.*)<\/title/', '/thumbnail\surl="(.*)"\/>/', '/thumbnail\surl="(.*)"\/>/', '/title>(.*)<\/title/'));

            break;
          case "flashgallery":
            $results = array_merge ($results, readXML($text, $dir,'/title="\/(.*)\/"\/>/', '/<pic\ssrc="(.*)"\stitle=/', '/<pic\ssrc="(.*)"\stitle=/', '/title="\/(.*)\/"\/>/'));
            break;
          case "futura":
            $files = read_all_files($dir);
            if (is_array($files['files'])) {
              foreach ($files['files'] as $file) {
                 $xml = new JSimpleXML;
                @$xml->loadFile($file);
                foreach ($xml->document->pic as $child) {
                  if (strpos($child->_attributes['image'], "exemple.xx")<=0) {
                    $res = new stdClass();
                    $res->title =  $child->_attributes['title'];
                    $res->image =  $child->_attributes['image'];
                    $res->href =  $child->_attributes['image'];
                    $res->text = $child->_attributes['title'];
                    $words = array();
                    $words = explode(' ', $text);
                    foreach ($words as $word) {
                      if ($word!="" && strpos($res->title, $word)!==false) {
                        $results[] = $res;
                        break;
                      }
                    }
                  }
                }
              }
            }           
            break;
          case "tilt3d":
            $dir = dirname(__FILE__).DS."..".DS."..".DS."..".DS."components".DS."com_oziogallery3".DS."skin".DS."tiltviewer".DS;
            
            $files = read_all_files($dir);
            if (is_array($files['files'])) {
              foreach ($files['files'] as $file) {
                $xml = new JSimpleXML;
                @$xml->loadFile($file);
                foreach ($xml->document->photos[0]->photo as $child) {
                  if (strpos($child->_attributes['imageurl'], "exemple.xx")<=0) {
                    $res = new stdClass();
                    $res->title =  $child->title[0]->_data;
                    $res->image =  $child->_attributes['imageurl'];
                    $res->href =  $child->_attributes['linkurl'];
                    $res->text = $child->description[0]->_data;
                    $words = array();
                    $words = explode(' ', $text);
                    foreach ($words as $word) {
                      if ($word!="" && strpos($res->title, $word)!==false) {
                        $results[] = $res;
                        break;
                      }
                    }
                  }
                }
              }
            }           
            break;
        }

      }
    }
		return $results;
	}
}